﻿function Banner(){
    Write-Host "`n###################################################" -ForegroundColor Cyan
    Write-Host "##         DelugeAntiSeeder by CHDuelund         ##" -ForegroundColor Cyan
    Write-Host "##  Find more useful solutions at Duelund.tech!  ##" -ForegroundColor Cyan
    Write-Host "###################################################" -ForegroundColor Cyan
}

$ErrorActionPreference = "SilentlyContinue"
$DelugeConsolePath = "C:\Program Files\Deluge\deluge-console.exe"

while (0 -lt 1) {
    $DelugeDProcess = Get-Process deluged
    $DelugeProcess = Get-Process deluge
    
    if ($DelugeDProcess -eq $null) {
        cls
        Banner
        Write-Host "`nDeluge Daemon process not detected - waiting..." -ForegroundColor Yellow
    }

    if ($DelugeDProcess -ne $null) { 
        $GetDownloads = & $DelugeConsolePath info
        $Downloading = $GetDownloads -match "\[D\]"
        $Downloads = $Downloading.Count
        cls
        Banner
        Write-Host "`nDeluge Daemon process detected - monitoring downloads..." -ForegroundColor Green
        Write-Host "Current number of active downloads:" $Downloads -ForegroundColor Green

        $GetID = $GetDownloads -match "\[S\]"

        foreach ($Object in $GetID) {
            $ID = $Object -split ' ' | select -Last 1
            & $DelugeConsolePath del $ID --confirm
            Write-Host "Torrent with ID $ID removed..." -ForegroundColor Yellow
        }
    }
    
    Start-Sleep 3
}

Pause